--[[------------------------------------------------
	-- Love Frames - A GUI library for LOVE --
	-- Copyright (c) 2013 Kenny Shields --
--]]------------------------------------------------

-- columnlistrow class
local newobject = loveframes.NewObject("columnlistrow", "loveframes_object_columnlistrow", true)

--[[---------------------------------------------------------
	- func: initialize()
	- desc: intializes the element
--]]---------------------------------------------------------
function newobject:initialize(parent, data)

	self.type = "columnlistrow"
	self.parent = parent
	self.state = parent.state
	self.colorindex = self.parent.rowcolorindex
	self.font = GetFont("AlteHaas.ttf",15)
	self.width = 80
	self.height = self.parent.parent.rowheight or 25
	self.textx = 5
	self.texty = 5
	self.selected = false
	self.internal = true
	self.columndata = data

	-- apply template properties to the object
	loveframes.templates.ApplyToObject(self)



	--]]
end

--[[---------------------------------------------------------
	- func: update(deltatime)
	- desc: updates the object
--]]---------------------------------------------------------
function newobject:update(dt)

	local visible = self.visible
	local alwaysupdate = self.alwaysupdate

	if not visible then
		if not alwaysupdate then
			return
		end
	end

	local parent = self.parent
	local base = loveframes.base
	local update = self.Update

	local hover = self.hover
	self:CheckHover()

	if self.hover and not hover then
		local onHover = self.parent.parent.OnRowHovered
		if onHover then onHover(self.parent.parent, self, self.columndata) end
	end

	-- move to parent if there is a parent
	if parent ~= base then
		self.x = parent.x + self.staticx
		self.y = parent.y + self.staticy
	end

	if update then
		update(self, dt)
	end

	if(self.mouseInTrash and _mouseUp[1])then
		if(self.parent.parent.trashFunc)then self.parent.parent:trashFunc(self) end
	end


end

--[[---------------------------------------------------------
	- func: draw()
	- desc: draws the object
--]]---------------------------------------------------------
function newobject:draw()

	local visible = self.visible

	if not visible then
		return
	end

	local skins = loveframes.skins.available
	local skinindex = loveframes.config["ACTIVESKIN"]
	local defaultskin = loveframes.config["DEFAULTSKIN"]
	local selfskin = self.skin
	local skin = skins[selfskin] or skins[skinindex]
	local drawfunc = skin.DrawColumnListRow or skins[defaultskin].DrawColumnListRow
	local draw = self.Draw
	local drawcount = loveframes.drawcount

	-- set the object's draw order
	self:SetDrawOrder()

	if draw then
		draw(self)
	else
		drawfunc(self)
	end



end

--[[---------------------------------------------------------
	- func: mousepressed(x, y, button)
	- desc: called when the player presses a mouse button
--]]---------------------------------------------------------
function newobject:mousepressed(x, y, button)

	if not self.visible then
		return
	end

	local hover = self.hover

	if hover and button == 1 then
		local baseparent = self:GetBaseParent()
		if baseparent and baseparent.type == "frame" then
			baseparent:MakeTop()
		end
		local parent1 = self:GetParent()
		local parent2 = parent1:GetParent()
		local ctrldown = love.keyboard.isDown("lctrl")
		parent2:SelectRow(self, ctrldown)
	end

end

--[[---------------------------------------------------------
	- func: mousereleased(x, y, button)
	- desc: called when the player releases a mouse button
--]]---------------------------------------------------------
function newobject:mousereleased(x, y, button)

	if not self.visible then
		return
	end

	if self.hover then
		local parent1 = self:GetParent()
		local parent2 = parent1:GetParent()
		if button == 1 then
			local onrowclicked = parent2.OnRowClicked
			if onrowclicked then
				onrowclicked(parent2, self, self.columndata)
			end
		elseif button == 2 then
			local onrowrightclicked = parent2.OnRowRightClicked
			if onrowrightclicked then
				onrowrightclicked(parent2, self, self.columndata)
			end
		end
	end

end

--[[---------------------------------------------------------
	- func: SetTextPos(x, y)
	- desc: sets the positions of the object's text
--]]---------------------------------------------------------
function newobject:SetTextPos(x, y)

	self.textx = x
	self.texty = y

end

--[[---------------------------------------------------------
	- func: GetTextX()
	- desc: gets the object's text x position
--]]---------------------------------------------------------
function newobject:GetTextX()

	return self.textx

end

--[[---------------------------------------------------------
	- func: GetTextY()
	- desc: gets the object's text y position
--]]---------------------------------------------------------
function newobject:GetTextY()

	return self.texty

end

--[[---------------------------------------------------------
	- func: SetFont(font)
	- desc: sets the object's font
--]]---------------------------------------------------------
function newobject:SetFont(font)

	self.font = font

end

--[[---------------------------------------------------------
	- func: GetFont()
	- desc: gets the object's font
--]]---------------------------------------------------------
function newobject:GetFont()

	return self.font

end

--[[---------------------------------------------------------
	- func: GetColorIndex()
	- desc: gets the object's color index
--]]---------------------------------------------------------
function newobject:GetColorIndex()

	return self.colorindex

end

--[[---------------------------------------------------------
	- func: SetColumnData(data)
	- desc: sets the object's column data
--]]---------------------------------------------------------
function newobject:SetColumnData(data)

	self.columndata = data

end

--[[---------------------------------------------------------
	- func: GetColumnData()
	- desc: gets the object's column data
--]]---------------------------------------------------------
function newobject:GetColumnData()

	return self.columndata

end

--[[---------------------------------------------------------
	- func: SetSelected(selected)
	- desc: sets whether or not the object is selected
--]]---------------------------------------------------------
function newobject:SetSelected(selected)

	self.selected = true

end

--[[---------------------------------------------------------
	- func: GetSelected()
	- desc: gets whether or not the object is selected
--]]---------------------------------------------------------
function newobject:GetSelected()

	return self.selected

end
